package au.edu.uts.aip.week1challenge;

import java.io.*;
import java.text.*;

/**
 * Main class for a solution to Design Challenge 2.
 * <p>
 * To run this file, right click on the class name in the Project view and then 
 * click "Run".
 * <p>
 * Please note that:
 * <ul>
 * <li> This code is not perfect! There are many ways it could be improved.
 * <li> I've chosen to focus on some aspects of the problem, you might have chosen something else.
 * <li> It doesn't do any escaping of HTML and has very little error checking.
 * <li> If you're still learning Java, don't worry if you don't understand all the code.
 *      You should put your energies into understanding the sample solutions to the practice activities.
 *      You can always revisit this solution later in the year, once your understanding of Java has improved.
 * <li> If you'd like to discuss your own solution, feel free to bring it along to the next lab.
 * </ul>
 */
public class DesignChallenge {
    
    public static void main(String[] args) throws IOException {
        // Read an address book from the filesystem
        AddressBook contacts = new AddressBook();
        contacts.readFromFile("addresses.csv");
       
        // A table transforms objects into HTML
        // Set up the table to render contacts in the address book
        Table<Person> table = new Table<>();
        table.addColumn("First Name", contact -> contact.getFirstName());
        table.addColumn("Last Name", contact -> contact.getLastName());
        table.addColumn("Phone Number", contact -> contact.getPhone());
        SimpleDateFormat dateFormat = new SimpleDateFormat("d MMMM yyyy");
        table.addColumn("Date of Birth", contact -> dateFormat.format(contact.getDateOfBirth()));
        table.addColumn("Gender", contact -> contact.getGender().toString());
        
        // Generate the HTML
        String result = table.format(contacts);
        
        // Show the user
        au.edu.uts.aip.week1challenge.MiniBrowser.show(result);
    }
    
}
