package au.edu.uts.aip.week1challenge;

import java.io.*;
import java.nio.file.*;
import java.text.*;
import java.util.*;

/**
 * An AddressBook is a collection of People (i.e., contacts).
 */
public class AddressBook implements Iterable<Person> {
    
    private static final SimpleDateFormat SAVED_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        
    private ArrayList<Person> contacts;
    
    public AddressBook() {
        contacts = new ArrayList<>();
    }
    
    /**
     * Reads a CSV file of contacts in first,last,phone,dob,gender format
     * @param fileName the filename containing contact data
     * @throws IOException if the supplied file cannot be read
     */
    public void readFromFile(String fileName) throws IOException {
        Path path = Paths.get(fileName);
        Files.lines(path).forEach(line -> {
            
            // Only process non-blank lines
            if (line.trim().length() != 0) {
                
                // Split on tabs
                String[] parts = line.split("\t");
                try {
                    // If there's enough columns, then create a Person
                    if (parts.length == 5) {
                        Person person = new Person(
                                parts[0],
                                parts[1],
                                parts[2],
                                SAVED_DATE_FORMAT.parse(parts[3]),
                                Gender.valueOf(parts[4])
                        );
                        contacts.add(person);
                    } else {
                        throw new ParseException("Invalid record encountered", 0);
                    }
                } catch (ParseException pe) {
                    // Not a great idea, but we'll just ignore formatting errors
                    pe.printStackTrace();
                }
            }
        });
    }
    
    /**
     * Adds a contact to the address book.
     * @param contact the contact to add
     */
    public void add(Person contact) {
        contacts.add(contact);
    }

    /**
     * Iterates over the contacts in the address book
     * @return an iterator for the contacts in the address book
     */
    @Override
    public Iterator<Person> iterator() {
        return contacts.iterator();
    }

}
